function [ ] = REVS_CVM_DOR( test_data, model_data, varargin )
% function [ ] = REVS_CVM_DOR( test_data, model_data )
%   creates a Conventional Vehicle Model (CVM) DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% engine              = parse_varargs(varargin,'engine','');
% %time_range         = parse_varargs(varargin,'time_range',[model_data.time(1) model_data.time(end)]);
% time_range          = parse_varargs(varargin,'time_range',[]);
% analyze_ratios      = parse_varargs(varargin,'analyze_ratios',false,'toggle');
% vehicle_speed_units = parse_varargs(varargin,'vehicle_speed_units','mph','string');
% fuel_plots          = parse_varargs(varargin,'fuel_plots',false,'toggle');
% engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');
% accessory_plots     = parse_varargs(varargin,'accessory_plots',false,'toggle');

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
engine              = parse_varargs(varargin,'engine','');
%time_range         = parse_varargs(varargin,'time_range',[model_data.time(1) model_data.time(end)]);
time_range          = parse_varargs(varargin,'time_range',[]);
analyze_ratios      = parse_varargs(varargin,'analyze_ratios',false,'toggle');
vehicle_speed_units = parse_varargs(varargin,'vehicle_speed_units','mph','string');
fuel_plots          = parse_varargs(varargin,'fuel_plots',false,'toggle');
engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');
accessory_plots     = parse_varargs(varargin,'accessory_plots',false,'toggle');

if strcmpi(engine_speed_units,'rpm')
    engine_speed_units_label = 'RPM';
else
    engine_speed_units_label = 'rad/s';
end

if strcmpi(vehicle_speed_units,'mph')
    vehicle_speed_units_label = 'MPH';
else
    vehicle_speed_units_label = 'm/s';
end

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

%% engine operation plot
if isobject(engine)
    for i = 1:length(test_data)
%        REVS_plot_engine_bsfc(engine,'plot_test_data', test_data{i}, 'title', ['Test Data ' num2str(i)]);
        REVS_plot_engine(engine,'efficiency','plot_test_data', test_data{i}, 'title', ['Test Data ' num2str(i)]);
    end
%    REVS_plot_engine_bsfc(engine,'plot_test_data', model_data, 'title', 'Model Data', 'time_range', time_range);
    REVS_plot_engine(engine,'efficiency','plot_test_data', model_data, 'title', 'Model Data', 'time_range', time_range);
end

%% drive cycle and vehicle speed
DOR_time_plot({}, model_data, data_descriptor, ['vehicle.drive_cycle_speed_' vehicle_speed_units],'', 'model_pts', model_pts, 'line_color','g');
DOR_time_plot(test_data, model_data, data_descriptor, ['vehicle.speed_' vehicle_speed_units],['Vehicle Speed (' vehicle_speed_units_label ')'],'model_pts',model_pts, 'no_fig');

xlim([time_range(1)-.02*time_range(2) time_range(2)*1.02]);
legend off;


DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel_economy_mpg','Fuel Economy (MPG)','model_pts',model_pts);
legend('Location','SouthEast')

if fuel_plots
    %% fuel consumption plot (mass)
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.mass_g','Fuel Consumed (grams)','model_pts',model_pts);
    legend('Location','NorthWest')
    
    %% fuel consumption plot (volume)
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.volume_cc','Fuel Consumed (cc)','model_pts',model_pts);
    legend('Location','NorthWest')
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.volume_gal','Fuel Consumed (gal)','model_pts',model_pts);
    legend('Location','NorthWest')
    
    %% fuel consumption plot (energy)
    % DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.mass_g * test_data{i}.vehicle.fuel.energy_density_MJpkg','Fuel Energy Consumed (kJ)','model_pts',model_pts);
    % legend('Location','NorthWest')
    
    %% fuel consumption plot (cc/sec)
    %DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_ccps_filt(1)','Fuel Rate (cc/sec)','model_pts',model_pts);
    
    %DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_gps_filt(1)','Fuel Rate (g/sec)','model_pts',model_pts);
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_ccps','Fuel Rate (cc/sec)','model_pts',model_pts);
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_gps','Fuel Rate (g/sec)','model_pts',model_pts);
end

%% engine speed plot
DOR_time_plot({}, model_data, data_descriptor, ['transmission.gearbox_input_speed_' engine_speed_units],'','model_pts',model_pts,'line_color','g');
add_legend('trans input speed');
DOR_time_plot(test_data, model_data, data_descriptor, ['engine.speed_' engine_speed_units],['Engine Speed (' engine_speed_units_label ')'],'model_pts',model_pts,'no_fig');
add_legend('engine speed');

%% engine gross torque
DOR_time_plot(test_data, model_data, data_descriptor, 'engine.gross_torque_Nm','Engine Gross Torque','model_pts',model_pts);

%% engine crankshaft torque
DOR_time_plot(test_data, model_data, data_descriptor, 'engine.crankshaft_torque_Nm','Engine Crankshaft Torque','model_pts',model_pts);

%% engine gross power
DOR_time_plot(test_data, model_data, data_descriptor, 'engine.gross_power_kW','Engine Gross Power','model_pts',model_pts);

%% accel pedal plot
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.accel_pedal_pct','Accel Pedal (pct)','model_pts',model_pts);

%% brake pedal plot
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.brake_pedal_pct','Brake Pedal (pct)','model_pts',model_pts);

%% lockup
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.launch_device_lockup_norm','Launch Device Lockup','model_pts',model_pts);

% % return;
% %% gear ratio plot
% if model_data.transmission.type == enum_transmission_type.CVT
%     DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.current_CVT_ratio','CVT Ratio','model_pts',model_pts);
% end
%
% %% gearbox input speed v. vehicle speed plot
% DOR_xy_plot(test_data, model_data, data_descriptor, 'vehicle.speed_mph', 'Vehicle Speed (mph)', 'transmission.gearbox_input_speed_rpm', 'Transmission Input Speed (RPM)', 'model_pts', (model_data.vehicle.speed_mph > 0) & model_pts, 'line_style', '');
%
% %% gear ratio v. speed plot
%
% if model_data.transmission.type == enum_transmission_type.CVT
%     DOR_xy_plot(test_data, model_data, data_descriptor, 'vehicle.speed_mph', 'Vehicle Speed (mph)', 'transmission.current_CVT_ratio', 'CVT Ratio', 'model_pts', (model_data.vehicle.speed_mph > 0) & model_pts, 'line_style', '');
% end
%
%% gear number v. time
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.commanded_gear_number','Commanded Gear Number','model_pts',model_pts);

%% gearbox input torque
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.gearbox_input_torque_Nm','Gearbox Input Torque','model_pts',model_pts);

%% gearbox output torque
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.output_torque_Nm','Gearbox Output Torque','model_pts',model_pts);

%% wheel torque
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.wheel_torque_Nm','Vehicle Wheel Torque','model_pts',model_pts);

%% gearbox output torque
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.output_torque_Nm','Gearbox Output Torque','model_pts',model_pts);

%% gearbox output speed
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.gearbox_output_speed_rpm','Geabox Output Speed','model_pts',model_pts);

%% gearbox input speed
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.gearbox_input_speed_rpm','Gearbox Input Speed','model_pts',model_pts);

%% tire speed
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.wheel_speed_rpm','Wheel Speed','model_pts',model_pts);

if analyze_ratios
    REVS_ratios_DOR( test_data, model_data, varargin{:} );
end

if accessory_plots
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.alternator_electrical_kW', 'Alternator Electrical Power', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.alternator_mechanical_kW', 'Alternator Mechanical Power', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery_kW', 'Battery Power', 'model_pts', model_pts);
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.alternator_A', 'Alternator Current', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery_A', 'Battery Current', 'model_pts', model_pts);
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery_V', 'Battery Voltage', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery_SoC_norm', 'Battery SoC', 'model_pts', model_pts);
    ylim([0 1]);
end

end

%% ----------------------- local functions -------------------------------
function [] = DOR_xy_plot( test_data, model_data, data_descriptor, x_signal_str, x_signal_descriptor, y_signal_str, y_signal_descriptor, varargin)
model_pts = parse_varargs(varargin,'model_pts',[]);
line_style = parse_varargs(varargin,'line_style','-');
line_color = parse_varargs(varargin,'line_color','b','string');
new_figure = parse_varargs(varargin,'no_fig',true,'toggle');

if new_figure
    figure;
else
    hold on;
end

for i = 1:length(test_data)
    plothg(eval(['test_data{i}.' x_signal_str]), eval(['test_data{i}.' y_signal_str]),['r.' line_style]);
    add_legend('data');
end
if isempty(model_pts)
    plothg(eval(['model_data.' x_signal_str]),  eval(['model_data.' y_signal_str]),[line_color '.' line_style]);
else
    plothg(eval(['model_data.' x_signal_str '(model_pts)']),  eval(['model_data.' y_signal_str '(model_pts)']),[line_color '.' line_style]);
end
add_legend('model');

xyt(x_signal_descriptor,[data_descriptor ' ' y_signal_descriptor]);

end

%%
function [] = DOR_time_plot( test_data, model_data, data_descriptor, signal_str, signal_descriptor, varargin)
    DOR_xy_plot( test_data, model_data, data_descriptor, 'time', 'Time (S)', signal_str, signal_descriptor, varargin{:});
end
